jQuery(document).ready(function($) {

	var daln_archived_ticker_data_xml = '';
	var daln_ticker_cycles = 0;

	/*
	 * Append the ticker in the DOM if the daln_apply_ticker flag is defined
	 */
	if ( typeof daln_apply_ticker != 'undefined' && daln_apply_ticker ){

		//append the ticker before the ending body tag
		daln_append_html();

		//refresh the news only if the news ticker is in "open" status
		if (( $("#daln-container").css("display") == "block") ){

			//refresh the news
			daln_refresh_news();

		}

		/*
		 * If the clock is based on the user time and the clock_autoupdate option enabled set the interval used to
		 * update the clock
		 */
		if(daln_clock_source == 2 && daln_clock_autoupdate == 1) {
			window.setInterval(daln_set_clock_based_on_user_time, (daln_clock_autoupdate_time * 1000) );
		}

	}

	/*
	 * This function is used to refresh all the data displayed in the ticker and to animate the sliding news from the
	 * initial to the final destination. It's called in the following situations:
	 *
	 * - When the document is ready
	 * - When a cycle of sliding news has finished its animation
	 * - When the news ticker is opened with the open button
	 */
	function daln_refresh_news(){

		if(typeof daln_ticker_transient != 'undefined' && daln_ticker_transient !== null){

			//Convert the XML string to a JavaScript XML Document
      daln_archived_ticker_data_xml = $.parseXML(daln_ticker_transient);

			//Set the transient to null so it won't be used multiple times
			daln_ticker_transient = null;

		}

		if( $.isXMLDoc( daln_archived_ticker_data_xml) === false || daln_ticker_cycles >= daln_cached_cycles ){

			//retrieve the news with ajax and refresh the news ---------------------------------------------------------

			daln_ticker_cycles = 0;

			//set ajax in synchronous mode
			jQuery.ajaxSetup({async:false});

			//prepare input for the ajax request
			var data = {
				"action": "get_ticker_data",
				"security": daln_nonce,
				"ticker_id": daln_ticker_id
			};

			//ajax
			$.post(daln_ajax_url, data, function(ticker_data_xml) {

				daln_archived_ticker_data_xml = ticker_data_xml;

				daln_update_the_clock(ticker_data_xml);

				daln_refresh_featured_news(ticker_data_xml);

				daln_refresh_sliding_news(ticker_data_xml);

				daln_slide_the_news();

			});

			//set ajax in asynchronous mode
			jQuery.ajaxSetup({async:true});

		}else{

			//use the current ticker xml data to refresh the news ------------------------------------------------------

			daln_ticker_cycles++;

			daln_update_the_clock(daln_archived_ticker_data_xml);

			daln_refresh_featured_news(daln_archived_ticker_data_xml);

			daln_refresh_sliding_news(daln_archived_ticker_data_xml);

			daln_slide_the_news();

		}

	}

	/*
	 * Update the clock
	 */
	function daln_update_the_clock(ticker_data_xml){

		if(daln_clock_source == 2){

			//update the clock based on the user time ------------------------------------------------------------------
			daln_set_clock_based_on_user_time();

		}else{

			//update the clock based on the server time ----------------------------------------------------------------
			var currentTime = $(ticker_data_xml).find('time').text();

      var timestamp = moment.unix(currentTime).utc();
			$("#daln-clock").text(timestamp.format(daln_clock_format));

		}

	}

	/*
	 * Remove the featured news title and excerpt from the DOM and uses the ticker data in XML format data to append the
	 * news featured news title and excerpt
	 */
	function daln_refresh_featured_news(ticker_data_xml){

		//parse the xml string
		$(ticker_data_xml).find("featurednews news").each(function(){

			var news_title = $(this).find("newstitle").text();
			var news_excerpt = $(this).find("newsexcerpt").text();
			var url = $(this).find("url").text();

			//Delete the featured title
			$('#daln-featured-title').html("");

			//Delete the featured excerpt
			$('#daln-featured-excerpt').html("");

			if( url.length > 0 && daln_enable_links ){

				//Append the new featured title
				$('#daln-featured-title').html( '<a target="' + daln_target_attribute + '" href="' + url + '">' + daln_htmlEscape( news_title ) + '</a>' );

				//Append the new featured excerpt
				$('#daln-featured-excerpt').html( daln_htmlEscape( news_excerpt ) );

			}else{

				//Append the new featured title
				$('#daln-featured-title').html(  daln_htmlEscape( news_title )  );

				//Append the new featured excerpt
				$('#daln-featured-excerpt').html( daln_htmlEscape( news_excerpt ) );

			}

		});

	}

	/*
	 * Deletes all the sliding news from the DOM and uses the ticker data in XML format to append the news sliding news
	 */
	function daln_refresh_sliding_news(ticker_data_xml){

		//Delete the previous sliding news
		$('#daln-slider-floating-content').empty();

		//parse the xml string
		$(ticker_data_xml).find("slidingnews news").each(function(){

			var news_title = $(this).find("newstitle").text();
			var url = $(this).find("url").text();
			var text_color = $(this).find("text_color").text();
			var text_color_hover = $(this).find("text_color_hover").text();
			var background_color = $(this).find("background_color").text();
			var background_color_opacity = $(this).find("background_color_opacity").text();
			var image_before = $(this).find("image_before").text();
			var image_after = $(this).find("image_after").text();

			//generate the style for the text color
			if( text_color.trim().length > 0 ){
				var style_text_color = 'style="color: ' + text_color + ';"';
			}else{
				var style_text_color = '';
			}

			//generate the style for the background color
			if( background_color.trim().length > 0 ) {
				var color_a = rgb_hex_to_dec(background_color);
				var style_background_color = 'style="background: rgba(' + color_a['r'] + ',' + color_a['g'] + ',' + color_a['b'] + ',' + parseFloat(background_color_opacity) + ');"';
			}else{
				var style_background_color = '';
			}

			//generate the image_before html
			if(image_before.trim().length > 0){
				var image_before_html = '<img class="daln-image-before" src="' + image_before + '">';
			}else{
				var image_before_html = '';
			}

			//generate the image_after html
			if(image_after.trim().length > 0){
				var image_after_html = '<img class="daln-image-after" src="' + image_after + '">';
			}else{
				var image_after_html = '';
			}

			//check if is set the RTL layout option
			if( daln_rtl_layout == 0 ){

				//LTR layout -----------------------------------------------------------------------
				if( url.length > 0 && daln_enable_links ){
					$('#daln-slider-floating-content').append( '<div ' + style_background_color + ' class="daln-slider-single-news">' + image_before_html + '<a data-text-color="' + text_color + '" onmouseout=\'jQuery(this).css("color", jQuery(this).attr("data-text-color"))\' onmouseover=\'jQuery(this).css("color", "' + text_color_hover + '" )\' ' + style_text_color + ' target="' + daln_target_attribute + '" href="' + url + '">' + daln_htmlEscape( news_title ) + '</a>' + image_after_html + '</div>' );
				}else{
					$('#daln-slider-floating-content').append( '<div ' + style_background_color + ' class="daln-slider-single-news">' + image_before_html + '<span ' + style_text_color + ' >' + daln_htmlEscape( news_title ) + '</span>' + image_after_html + '</div>' );
				}

			}else{

				//RTL layout -----------------------------------------------------------------------
				if( url.length > 0 && daln_enable_links ){
					$('#daln-slider-floating-content').prepend( '<div ' + style_background_color + ' class="daln-slider-single-news">' + image_before_html + '<a  data-text-color="' + text_color + '" onmouseout=\'jQuery(this).css("color", jQuery(this).attr("data-text-color"))\' onmouseover=\'jQuery(this).css("color", "' + text_color_hover + '" )\' ' + style_text_color + ' target="' + daln_target_attribute + '" href="' + url + '">' + daln_htmlEscape( news_title ) + '</a>' + image_after_html + '</div>' );
				}else{
					$('#daln-slider-floating-content').prepend( '<div ' + style_background_color + ' class="daln-slider-single-news">' + image_before_html + '<span ' + style_text_color + ' >' + daln_htmlEscape( news_title ) + '</span>' + image_after_html + '</div>' );
				}

			}
		});

	}

	/*
	 * Slides the news with jQuery animate from the initial to the final position. When the animation is complete calls
	 * daln_refresh_news() which restarts the process from the start.
	 */
	function daln_slide_the_news(){

		//if the news slider is already animated then return
		if( ( $('#daln-slider-floating-content:animated').length ) == 1 ){ return; };

		//get browser with
		var window_width = $(window).width();

		//floating news width
		var floating_news_width =parseInt( $( "#daln-slider-floating-content" ).css("width") );

		//check if is set the RTL layout option
		if( daln_rtl_layout == 0 ){

			//LTR layout -----------------------------------------------------------------------

			//position outside the screen to the left
			var outside_left = floating_news_width + window_width;

			//set floating content left position outside the screen
			$( "#daln-slider-floating-content" ).css("left", window_width );

			//start floating the news
			$( "#daln-slider-floating-content" ).delay(daln_sliding_delay).animate({
				left: "-=" + outside_left,
				easing: "linear"
			}, ( outside_left * daln_sliding_speed ), "linear", function() {

				//animation complete
				daln_refresh_news();

			});

		}else{

			//RTL layout -----------------------------------------------------------------------

			//position outside the screen to the left
			var outside_left = floating_news_width + window_width;

			//set floating content left position outside the screen
			$( "#daln-slider-floating-content" ).css("left", - floating_news_width );

			//start floating the news
			$( "#daln-slider-floating-content" ).delay(daln_sliding_delay).animate({
				left: "+=" + outside_left,
				easing: "linear"
			}, ( outside_left * daln_sliding_speed ), "linear", function() {

				//animation complete
				daln_refresh_news();

			});

		}

	}

	/*
	 * On the click event of the "#daln-close" element closes the news ticker and sends an ajax request used to save the
	 * "closed" status in the "live_news_status" cookie
	 */
	$("#daln-close").click(function() {

		//Stop the animation
		$("#daln-slider-floating-content").stop();

		//Delete the previous sliding news
		$('#daln-slider-floating-content').empty();

		//Hide the news container
		$("#daln-container").hide();

		//Show the open button
		$("#daln-open").show();

        //prepare input for the ajax request
        var data = {
            "action": "set_status_cookie",
            "security": daln_nonce,
            "status": "closed"
        };

        //ajax
        $.post(daln_ajax_url, data, function(ajax_response) {

			if( ajax_response == "success" ){
				//nothing
			}

        });

		//set the status hidden field to closed
		$("#daln-status").attr("value","closed");

	});

	/*
	 * On the click event of the "#daln-open" element opens the news ticker and sends an ajax request used to save the
	 * "open" status in the "live_news_status" cookie
	 */
	$("#daln-open").click(function() {

		//Show the news container
		$("#daln-container").show();

		//Show the open button
		$("#daln-open").hide();

		daln_refresh_news();

        //prepare input for the ajax request
        var data = {
            "action": "set_status_cookie",
            "security": daln_nonce,
            "status": "open"
        };

        //ajax
        $.post(daln_ajax_url, data, function(ajax_response) {

			if( ajax_response == "success" ){
				//nothing
			}

        });

		//set the status hidden field to open
		$("#daln-status").attr("value","open");

	});

	/*
	 * Converts certain characters to their HTML entities
	 */
	function daln_htmlEscape(str) {
	    return String(str)
			.replace(/&/g, '&amp;')
			.replace(/"/g, '&quot;')
			.replace(/'/g, '&#39;')
			.replace(/</g, '&lt;')
			.replace(/>/g, '&gt;');
	}

	/*
	 * Appends the ticker HTML just before the ending body element
	 */
	function daln_append_html(){

		html_output = '<div id="daln-container">' +

			'<!-- featured news -->' +
			'<div id="daln-featured-container">' +
				'<div id="daln-featured-title-container">' +
					'<div id="daln-featured-title"></div>' +
				'</div>' +
				'<div id="daln-featured-excerpt-container">' +
					'<div id="daln-featured-excerpt"></div>' +
				'</div>' +
			'</div>' +

			'<!-- slider -->' +
			'<div id="daln-slider">' +
				'<!-- floating content -->' +
				'<div id="daln-slider-floating-content"></div>' +
			'</div>' +

			'<!-- clock -->' +
			'<div id="daln-clock"></div>' +

			'<!-- close button -->' +
			'<div id="daln-close"></div>' +

		'</div>' +

		'<!-- open button -->' +
		'<div id="daln-open"></div>';

		$('body').append(html_output);

	}

	/*
	 * Uses a "Date" object to retrieve the user time and adds the clock offset of this news ticker
	 */
	function daln_set_clock_based_on_user_time(){

		//Get the current unix timestamp and add the offset
		var timestamp = moment().unix() + daln_clock_offset;

		//Convert the unix timestamp to the provided format
		var time = moment.unix(timestamp).format(daln_clock_format);

		//Update the DOM
    $("#daln-clock").text(time);

	}

	/*
	 * Given an hexadecimal rgb color an array with the 3 components converted in decimal is returned
	 *
	 * @param string The hexadecimal rgb color
	 * @return array An array with the 3 component of the color converted in decimal
	 */
	function rgb_hex_to_dec(hex){

		//remove the # character
		var hex = hex.replace('#', '');

		//find the component of the color
		if ( hex.length == 3 ) {
			var r = parseInt(hex.substring(0, 1), 16);
			var g = parseInt(hex.substring(1, 2), 16);
			var b = parseInt(hex.substring(2, 3), 16);
		} else {
			var r = parseInt(hex.substring(0, 2), 16);
			var g = parseInt(hex.substring(2, 4), 16);
			var b = parseInt(hex.substring(4, 6), 16);
		}

		//generate the array with the component of the color
		var color_a = new Array();
		color_a['r'] = r;
		color_a['g'] = g;
		color_a['b'] = b;

		return color_a;

	}

});